/*
 * Decompiled with CFR 0.152.
 */
package pt.caf_pbs.schooldiskapi.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import pt.caf_pbs.schooldiskapi.exceptions.DuplicatedDataException;
import pt.caf_pbs.schooldiskapi.model.Date;
import pt.caf_pbs.schooldiskapi.model.EnrollContainer;
import pt.caf_pbs.schooldiskapi.model.Student;

@JsonIgnoreProperties(value={"all"})
public class StudentContainer
implements Serializable {
    private List<Student> students = new ArrayList();
    private EnrollContainer enrolls;

    public List<Student> getStudents() {
        return this.students;
    }

    public void setStudents(List<Student> students) {
        this.students = students;
    }

    public EnrollContainer getEnrolls() {
        return this.enrolls;
    }

    public void setEnrolls(EnrollContainer enrolls) {
        this.enrolls = enrolls;
    }

    private Student search(int number) {
        for (Student student : this.students) {
            if (!student.isEqualTo(number)) continue;
            return student;
        }
        return null;
    }

    public List<Student> getAll() {
        ArrayList<Student> newlist = new ArrayList<Student>();
        newlist.addAll(this.students);
        return newlist;
    }

    public Student get(int number) {
        Student student = this.search(number);
        return student;
    }

    public void add(Student obj) {
        Student student = this.search(obj.getNumber());
        if (student != null) {
            String msg = "Student: " + obj.getNumber();
            throw new DuplicatedDataException(msg);
        }
        this.students.add(obj);
    }

    public void remove(int number) {
        Student student = this.search(number);
        if (student != null) {
            this.students.remove(student);
        }
    }

    public void update(int number, String name, Date date) {
        Student student = this.search(number);
        if (student != null) {
            student.setName(name);
            student.setBirthday(date);
        }
    }
}

